#ifndef TYPEDEFS_H
#define TYPEDEFS_H

#define INVALID	0x00
#define NEWDATA	0x01
#define PROCESSED	0x02

typedef struct
{
    int32_t Longitude;  // in 1E-7 deg
    int32_t Latitude;   // in 1E-7 deg
    int32_t Altitude;   // in mm
    uint8_t Status;    // validity of data
} __attribute__((packed)) GPS_Pos_t;


typedef struct
{
    GPS_Pos_t Position;          // the gps position of the waypoint, see ubx.h for details
    int16_t   Heading;           // orientation, future implementation
    uint8_t   ToleranceRadius;   // in meters, if the MK is within that range around the target, then the next target is triggered
    uint8_t   HoldTime;          // in seconds, if the was once in the tolerance area around a WP, this time defies the delay before the next WP is triggered
    uint8_t   Event_Flag;        // future emplementation
    uint8_t   reserve[12];       // reserve
} __attribute__((packed)) Waypoint_t;

typedef struct
  {
    char Revision;
    char Name[12];
    signed char Motor[16][4];
  } Mixer_t;

#endif // TYPEDEFS_H
